<?php namespace App\Controllers;

use App\Models\CamarasModel;

class Camaras extends BaseController
{
    protected $CamarasModel;

    public function __construct()
    {
        $this->CamarasModel = new CamarasModel();
    }

    public function index()
    {
        $model = $this->CamarasModel; // usar propiedad en vez de nueva instancia
        $search = $this->request->getGet();

        $page = (int) ($this->request->getVar('page') ?? 1);
        $perPage = 10;
        $offset = ($page - 1) * $perPage;

        $total = $model->getFilteredCount($search);
        $items = $model->getFilteredData($perPage, $offset, $search);

        $pager = \Config\Services::pager();
        $pager->makeLinks($page, $perPage, $total);

        return view('camaras/index', [
            'items' => $items,
            'pager' => $pager,
            'search' => $search
        ]);
    }

    public function create()
    {
        return view('camaras/create');
    }

    public function store()
    {
        $emptyToNull = function ($value) {
            return trim($value) === '' ? null : $value;
        };

        $data = [
            'codigo' => $this->request->getPost('codigo'),
            'otb' => $this->request->getPost('otb'),
            'distrito' => $emptyToNull($this->request->getPost('distrito')),
            'nombre_calle' => $this->request->getPost('nombre_calle'),
            'ubicacion' => $this->request->getPost('ubicacion'),
            'nom_cuenca' => $this->request->getPost('nombre_cuenca'),
            'este' => $emptyToNull($this->request->getPost('este')),
            'norte' => $emptyToNull($this->request->getPost('norte')),
            'altura' => $emptyToNull($this->request->getPost('altura')),
            'diametro' => $emptyToNull($this->request->getPost('diametro')),
            'forma' => $this->request->getPost('forma'),
            'cota' => $emptyToNull($this->request->getPost('cota')),
            'caida' => $emptyToNull($this->request->getPost('caida')),
            'estado' => $this->request->getPost('estado'),
            'numero_cruce' => $emptyToNull($this->request->getPost('numero_cruce')),
            'material_tapa' => $this->request->getPost('material_tapa'),
            'cod_activos_fijos' => $this->request->getPost('codigo_activos_fijos'),
            'fecha_instalacion' => $emptyToNull($this->request->getPost('fecha_instalacion')),
            'fecha_habilitacion' => $emptyToNull($this->request->getPost('fecha_habilitacion')),
            'valor_instalacion' => $emptyToNull($this->request->getPost('valor_instalacion')),
            'tipo_inversion' => $this->request->getPost('tipo_inversion'),
            'nom_proyecto' => $this->request->getPost('nombre_proyecto'),
            'emp_responsable' => $this->request->getPost('empresa_responsable'),
            'supervisor' => $this->request->getPost('supervisor'),
            'encargado_lev' => $this->request->getPost('encargado_levantamiento'),
            'resp_catastro' => $this->request->getPost('responsable_catastro'),
            'observaciones' => $this->request->getPost('observaciones'),
        ];

        $this->CamarasModel->insert($data);

        return redirect()->to(base_url('camaras'))->with('mensaje', 'Cámara registrada exitosamente.');
    }

    public function edit($id)
    {
        $camara = $this->CamarasModel->find($id);

        if (!$camara) {
            throw new \CodeIgniter\Exceptions\PageNotFoundException("Cámara no encontrada: $id");
        }

        return view('camaras/edit', [
            'camara' => $camara
        ]);
    }

  public function update($id)
{
    $data = $this->request->getPost();

    // Campos tipo entero
    $camposEnteros = [
        'numero_cruce',
        'altura',
        'diametro',
        'cota',
        'caida',
        'este',
        'norte',
        'valor_instalacion'
    ];

    // Campos tipo fecha
    $camposFecha = [
        'fecha_instalacion',
        'fecha_habilitacion'
    ];

    // Limpiar enteros
    foreach ($camposEnteros as $campo) {
        if (isset($data[$campo]) && $data[$campo] === '') {
            $data[$campo] = null;
        } elseif (isset($data[$campo])) {
            $data[$campo] = (int) $data[$campo];
        }
    }

    // Limpiar fechas
    foreach ($camposFecha as $campo) {
        if (isset($data[$campo]) && $data[$campo] === '') {
            $data[$campo] = null;
        }
    }

    $this->CamarasModel->update($id, $data);
    return redirect()->to('/camaras');
}



    public function view($id)
{
    $camaraModel = new \App\Models\CamarasModel();
    $camara = $camaraModel->find($id);

    if (!$camara) {
        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Cámara no encontrada");
    }

    return view('camaras/view', ['camara' => $camara]);
}


    public function delete($id)
    {
        $this->CamarasModel->delete($id);
        return redirect()->to('/camaras')->with('status', 'Registro eliminado correctamente');
    }
}

