<?php

namespace App\Controllers;

use App\Models\ConceptosModel;

class Conceptos extends BaseController
{
    protected $model;

    public function __construct()
    {
        $this->model = new ConceptosModel();
    }

    public function index()
    {
        $filtros = [
            'concepto'     => $this->request->getGet('concepto'),
            'nombre'       => $this->request->getGet('nombre'),
            'tipoconcepto' => $this->request->getGet('tipoconcepto'),
            'clase'        => $this->request->getGet('clase'),
            'referencia'   => $this->request->getGet('referencia'),
        ];

        $porPagina = 10;

        $data['items'] = $this->model
            ->buscar($filtros)
            ->orderBy('concepto', 'ASC')
            ->paginate($porPagina);

        $data['pager'] = $this->model->pager;
        $data['search'] = $filtros;

        return view('conceptos/index', $data);
    }

    public function create()
    {
        return view('conceptos/create');
    }

    public function store()
    {
        $data = $this->request->getPost();
        
        // Limpiar vacíos como null (especialmente fechas)
        foreach ($data as $key => $value) {
            $data[$key] = (trim($value) === '') ? null : $value;
        }
        
        $this->model->insert($data);

        return redirect()->to('/conceptos')->with('mensaje', 'Concepto creado correctamente');
    }

    public function edit($id)
    {
        $item = $this->model->find($id);
        if (!$item) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Registro no encontrado");
        }

        return view('conceptos/edit', ['item' => $item]);
    }

    public function update($id)
    {
        $data = $this->request->getPost();

        foreach ($data as $key => $value) {
            $data[$key] = (trim($value) === '') ? null : $value;
        }

        $this->model->update($id, $data);
        return redirect()->to('/conceptos')->with('mensaje', 'Concepto actualizado correctamente');
    }

    public function delete($id)
    {
        $this->model->delete($id);
        return redirect()->to('/conceptos')->with('status', 'Concepto eliminado correctamente');
    }
}
