<?php

namespace App\Controllers;

use App\Models\UserModel;

class Users extends BaseController
{
    protected $model;

    public function __construct()
    {
        $this->model = new UserModel();
    }

    public function index()
    {
        $filtros = [
            'username' => $this->request->getGet('username'),
            'email'    => $this->request->getGet('email'),
            'nombre'   => $this->request->getGet('nombre'),
            'apellido' => $this->request->getGet('apellido'),
            'estado'   => $this->request->getGet('estado'),
        ];

        $porPagina = 10;

        $data['items'] = $this->model
            ->buscar($filtros)
            ->orderBy('id', 'ASC')
            ->paginate($porPagina);

        $data['pager'] = $this->model->pager;
        $data['search'] = $filtros;

        return view('users/index', $data);
    }

    public function view($id)
    {
        $item = $this->model->find($id);

        if (!$item) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Usuario no encontrado");
        }

        return view('users/view', ['item' => $item]);
    }

    public function create()
    {
        return view('users/create');
    }

    public function store()
    {
        $data = $this->request->getPost();
        //$data['password_hash'] = password_hash($data['password_hash'], PASSWORD_DEFAULT);
        $encrypter = \Config\Services::encrypter();
    	$data['password_hash'] = bin2hex($encrypter->encrypt($data['password_hash']));        

        $this->model->insert_auditor($data);

        return redirect()->to('/users')->with('mensaje', 'Usuario creado correctamente');
    }

    public function edit($id)
    {
        $item = $this->model->find($id);

        if (!$item) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Usuario no encontrado");
        }

        return view('users/edit', ['item' => $item]);
    }

    public function update($id)
    {
        $data = $this->request->getPost();

        if (!empty($data['password_hash'])) {
            //$data['password_hash'] = password_hash($data['password_hash'], PASSWORD_DEFAULT);
            $encrypter = \Config\Services::encrypter();
    	    $data['password_hash'] = bin2hex($encrypter->encrypt($data['password_hash']));

        } else {
            unset($data['password_hash']);
        }

       // Asegurar que active sea 0 o 1
       $data['active'] = isset($data['active']) ? (int)$data['active'] : 0;
    
    
        foreach ($data as $key => $value) {
            $data[$key] = (trim($value) === '') ? null : $value;
        }

        $this->model->update_auditor($id, $data);

        return redirect()->to(base_url('users'))->with('mensaje', 'Usuario actualizado correctamente');
    }

    public function delete($id)
    {
        $this->model->delete_auditor($id);

        return redirect()->to(base_url('users'))->with('status', 'Usuario eliminado correctamente');
    }
}


