<?php namespace App\Controllers;

use App\Models\UsuarioModel;
use CodeIgniter\Controller;

class Usuarios extends Controller
{
    public function index()
    {
 
    	helper('form');
    
    	$usuarioModel = new UsuarioModel();

        // Obtener los filtros de la petición
        $filters = [
            'nombre'    => $this->request->getVar('nombre'),
            'apellido'  => $this->request->getVar('apellido'),
            'email'     => $this->request->getVar('email'),
            'id_grupo'  => $this->request->getVar('id_grupo'),
            'id_cliente'=> $this->request->getVar('id_cliente')
        ];

        // Configuración de paginación
        $perPage = 10; // Número de registros por página
        $page = $this->request->getVar('page') ?? 1;
        $offset = ($page - 1) * $perPage;

        // Obtener los usuarios con filtros y paginación
        $usuarios = $usuarioModel->getUsuarios($perPage, $offset, $filters);

        // Obtener la cantidad total de registros (con filtros aplicados)
        $totalUsuarios = $usuarioModel->getCount($filters);

        // Cargar la vista con los datos
        return view('usuarios/index', [
            'usuarios' => $usuarios,
            'pager'    => \Config\Services::pager()->makeLinks($page, $perPage, $totalUsuarios),
            'filters'  => $filters
        ]);
    }

    public function create()
    {
        return view('usuarios/create');
    }

    public function store()
    {
        $usuarioModel = new UsuarioModel();

        $data = [
            'nombre'      => $this->request->getPost('nombre'),
            'apellido'    => $this->request->getPost('apellido'),
            'email'       => $this->request->getPost('email'),
            'usuario'     => $this->request->getPost('usuario'),
            'f_nacimiento'=> $this->request->getPost('f_nacimiento'),
            'id_grupo'    => $this->request->getPost('id_grupo'),
            'id_cliente'  => $this->request->getPost('id_cliente'),
            'l_estado'    => $this->request->getPost('l_estado'),
        ];

        $usuarioModel->insert_auditor($data);

        return redirect()->to(base_url('usuarios'))->with('status', 'Usuario creado correctamente');
    }

    public function edit($id)
    {
        $usuarioModel = new UsuarioModel();
        $usuario = $usuarioModel->getUsuario($id);

        return view('usuarios/edit', ['usuario' => $usuario]);
    }

    public function update($id)
    {
        $usuarioModel = new UsuarioModel();

        $data = [
            'nombre'      => $this->request->getPost('nombre'),
            'apellido'    => $this->request->getPost('apellido'),
            'email'       => $this->request->getPost('email'),
            'usuario'     => $this->request->getPost('usuario'),
            'f_nacimiento'=> $this->request->getPost('f_nacimiento'),
            'id_grupo'    => $this->request->getPost('id_grupo'),
            'id_cliente'  => $this->request->getPost('id_cliente'),
            'l_estado'    => $this->request->getPost('l_estado'),
        ];

        $usuarioModel->update_auditor($id, $data);

        return redirect()->to(base_url('usuarios'))->with('status', 'Usuario actualizado correctamente');
    }

    public function delete($id)
    {
        $usuarioModel = new UsuarioModel();
        $usuarioModel->delete_auditor($id);

        return redirect()->to(base_url('usuarios'))->with('status', 'Usuario eliminado correctamente');
    }


}
