<?php

namespace App\Libraries;

use CodeIgniter\Database\ConnectionInterface;

class Auditoria
{
    protected $db;

    public function __construct(ConnectionInterface $db = null)
    {
        $this->db = $db ?? \Config\Database::connect();
    }

    public function actualizar_backend_pid()
    {
        $query = $this->db->query("SELECT pg_backend_pid() AS pid");
        $row = $query->getRow();
        $sesion = $row->pid;

        session()->set('sesion', $sesion);

        $login_attempts = [
            'user_id'     => session()->get('user_id'),
            'username'    => session()->get('username'),
            'login_time'  => date('Y-m-d H:i:s'),
            'ip_address'  => session()->get('ip_address'),
            'user_agent'  => session()->get('user_agent'),
            'sesion'      => $sesion,
            'success'     => true,
        ];

        $this->db->table('audit.login_attempts')->insert($login_attempts);
    }
}
