<?php namespace App\Models;

use CodeIgniter\Model;
use App\Libraries\Auditoria;

class CamarasModel extends Model
{
    protected $table = 'bdgeo.camaras';
    protected $primaryKey = 'gid';
    protected $allowedFields = [
        'codigo', 'nombre_calle', 'numero_cruce', 'este', 'norte', 'cota', 'fecha_instalacion',
        'tipo_inversion', 'nom_proyecto', 'emp_responsable', 'supervisor', 'encargado_lev',
        'resp_catastro', 'diametro', 'altura', 'estado', 'ubicacion', 'forma',
        'material_tapa', 'caida', 'nom_cuenca', 'valor_instalacion', 'cod_activos_fijos',
        'fecha_habilitacion', 'distrito', 'otb', 'observaciones'
    ];

    public function getFilteredData($limit, $offset, $filters = [])
    {
        $builder = $this->db->table($this->table);

        if (!empty($filters['codigo'])) {
            $builder->where("LOWER(codigo) ILIKE '%" . strtolower($filters['codigo']) . "%'");
        }
        if (!empty($filters['nombre_calle'])) {
            $builder->where("LOWER(nombre_calle) ILIKE '%" . strtolower($filters['nombre_calle']) . "%'");
        }
        if (!empty($filters['cota'])) {
            $builder->where("LOWER(cota) ILIKE '%" . strtolower($filters['cota']) . "%'");
        }
        if (!empty($filters['fecha_instalacion'])) {
            $builder->where("TO_CHAR(fecha_instalacion, 'YYYY-MM-DD') ILIKE '%" . strtolower($filters['fecha_instalacion']) . "%'");
        }
        
        if (!empty($filters['diametro'])) {
            $builder->where("LOWER(diametro) ILIKE '%" . strtolower($filters['diametro']) . "%'");
        }
        if (!empty($filters['nom_cuenca'])) {
            $builder->where("LOWER(nom_cuenca) ILIKE '%" . strtolower($filters['nom_cuenca']) . "%'");
        }
        if (!empty($filters['fecha_habilitacion'])) {
            $builder->where("TO_CHAR(fecha_habilitacion, 'YYYY-MM-DD') ILIKE '%" . strtolower($filters['fecha_habilitacion']) . "%'");
        }
        
        if (!empty($filters['distrito'])) {
            $builder->where("LOWER(distrito) ILIKE '%" . strtolower($filters['distrito']) . "%'");
        }

        $builder->orderBy('gid', 'ASC');

        return $builder->get($limit, $offset)->getResultArray();
    }

    public function getFilteredCount($filters = [])
    {
        $builder = $this->db->table($this->table);

        if (!empty($filters['codigo'])) {
            $builder->where("LOWER(codigo) ILIKE '%" . strtolower($filters['codigo']) . "%'");
        }
        if (!empty($filters['nombre_calle'])) {
            $builder->where("LOWER(nombre_calle) ILIKE '%" . strtolower($filters['nombre_calle']) . "%'");
        }
        if (!empty($filters['cota'])) {
            $builder->where("LOWER(cota) ILIKE '%" . strtolower($filters['cota']) . "%'");
        }
        if (!empty($filters['fecha_instalacion'])) {
            $builder->where("TO_CHAR(fecha_instalacion, 'YYYY-MM-DD') ILIKE '%" . strtolower($filters['fecha_instalacion']) . "%'");
        }
        
        if (!empty($filters['diametro'])) {
            $builder->where("LOWER(diametro) ILIKE '%" . strtolower($filters['diametro']) . "%'");
        }
        if (!empty($filters['nom_cuenca'])) {
            $builder->where("LOWER(nom_cuenca) ILIKE '%" . strtolower($filters['nom_cuenca']) . "%'");
        }
        if (!empty($filters['fecha_habilitacion'])) {
            $builder->where("TO_CHAR(fecha_habilitacion, 'YYYY-MM-DD') ILIKE '%" . strtolower($filters['fecha_habilitacion']) . "%'");
        }
        
        if (!empty($filters['distrito'])) {
            $builder->where("LOWER(distrito) ILIKE '%" . strtolower($filters['distrito']) . "%'");
        }

        return $builder->countAllResults();
    }
    
    public function insert_auditor($data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->insert($data);
        $db->transCommit();
        return true;
    } 
    
    public function update_auditor($id, $data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->update($id, $data);
        $db->transCommit();
        return true;
    } 
    
    public function delete_auditor($id)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->delete($id);
        $db->transCommit();
        return true;
    }     
}

