<?php

namespace App\Models;

use CodeIgniter\Model;
use App\Libraries\Auditoria;

class MantenimientoModel extends Model
{
    // Configuración de la base de datos
    protected $DBGroup          = 'default'; // Grupo de conexión a la base de datos
    protected $table            = 'red_agua_potable'; // Nombre de la tabla principal
    protected $primaryKey       = 'gid'; // Clave primaria de la tabla
    protected $useAutoIncrement = true; // Indica si la clave primaria es auto-incremental
    protected $returnType       = 'object'; // Tipo de retorno para los resultados ('array' o 'object')
    protected $useSoftDeletes   = false; // Habilitar o deshabilitar "borrado suave"
    protected $protectFields    = true; // Proteger campos de asignación masiva
    protected $allowedFields    = [
        'id_proyecto', 'numero_contrato', 'anyo_contrato', 'expediente', 'consultora',
        'descripcion', 'contratista', 'presupuesto', 'tipo_moneda', 'fecha_orden_proceder',
        'plazo_ejecucion', 'plazo_ejecucion_catastral', 'fecha_hora_insercion',
        'observaciones', 'usuario'
    ]; // Campos permitidos para inserción/actualización

    // Configuración de fechas
    protected $useTimestamps = false; // Habilitar o deshabilitar timestamps automáticos
    protected $dateFormat    = 'datetime'; // Formato de fecha
    protected $createdField  = 'fecha_hora_insercion'; // Campo para la fecha de creación
    protected $updatedField  = 'updated_at'; // Campo para la fecha de última actualización
    protected $deletedField  = 'deleted_at'; // Campo para la fecha de borrado suave

    // Reglas de validación (puedes definirlas aquí)
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks (funciones que se ejecutan antes/después de ciertas operaciones)
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    /**
     * Simula la función 'contador_registros' de CI3.
     * Cuenta el número de registros en una tabla específica con condiciones WHERE.
     *
     * @param string $table El nombre de la tabla.
     * @param array $where Un array asociativo de condiciones WHERE.
     * @return int El número de registros.
     */
    public function contadorRegistros(string $table, array $where = []): int
    {
        // Utiliza el constructor de consultas de la base de datos para contar.
        return $this->db->table($table)->where($where)->countAllResults();
    }

    /**
     * Simula la función 'eliminar_geometrias_proyecto' de CI3.
     * Implementa la lógica para eliminar las geometrías asociadas a un proyecto.
     *
     * @param int $id_proyecto El ID del proyecto.
     * @return bool Verdadero si la eliminación fue exitosa, falso en caso contrario.
     */
    public function eliminarGeometriasProyecto(int $id_proyecto): bool
    {
        // **IMPORTANTE**: Aquí debes implementar la lógica real de eliminación.
        // Esto dependerá de cómo estén estructuradas tus tablas de geometrías.
        // Ejemplo (descomenta y adapta según tus tablas):
        // $this->db->table('franja_dominio_pol')->where('id_proyec', $id_proyecto)->delete();
        // $this->db->table('franja_construccion')->where('id_proyec', $id_proyecto)->delete();
        // $this->db->table('eje')->where('id_proyec', $id_proyecto)->delete();
        // $this->db->table('progresivas')->where('id_proyec', $id_proyecto)->delete();
        // $this->db->table('ide_tramos')->where('id_proyecto', $id_proyecto)->delete();
        // $this->db->table('terrenos_ci')->where('id_proyec', $id_proyecto)->delete();
        // $this->db->table('mejoras_ci')->where('id_proyec', $id_proyecto)->delete();

        // Para fines de ejemplo, solo registramos un mensaje.
        log_message('info', "Eliminando geometrías para el proyecto ID: {$id_proyecto} (lógica pendiente)");
        return true; // Placeholder: asume éxito
    }

    /**
     * Simula la función 'eliminar_fd_proyecto' de CI3.
     * Elimina los datos de la tabla 'franja_dominio_pol' para un proyecto dado.
     *
     * @param int $id_proyecto El ID del proyecto.
     * @return bool Verdadero si la eliminación fue exitosa, falso en caso contrario.
     */
    public function eliminarFdProyecto(int $id_proyecto): bool
    {
        // Implementa la lógica para eliminar datos de 'franja_dominio_pol'
        // return $this->db->table('franja_dominio_pol')->where('id_proyec', $id_proyecto)->delete();
        log_message('info', "Eliminando Franja Dominio para el proyecto ID: {$id_proyecto} (lógica pendiente)");
        return true; // Placeholder
    }

    /**
     * Simula la función 'eliminar_fc_proyecto' de CI3.
     * Elimina los datos de la tabla 'franja_construccion' para un proyecto dado.
     *
     * @param int $id_proyecto El ID del proyecto.
     * @return bool Verdadero si la eliminación fue exitosa, falso en caso contrario.
     */
    public function eliminarFcProyecto(int $id_proyecto): bool
    {
        // Implementa la lógica para eliminar datos de 'franja_construccion'
        // return $this->db->table('franja_construccion')->where('id_proyec', $id_proyecto)->delete();
        log_message('info', "Eliminando Franja Construcción para el proyecto ID: {$id_proyecto} (lógica pendiente)");
        return true; // Placeholder
    }

    /**
     * Simula la función 'eliminar_progre_proyecto' de CI3.
     * Elimina los datos de la tabla 'progresivas' para un proyecto dado.
     *
     * @param int $id_proyecto El ID del proyecto.
     * @return bool Verdadero si la eliminación fue exitosa, falso en caso contrario.
     */
    public function eliminarProgreProyecto(int $id_proyecto): bool
    {
        // Implementa la lógica para eliminar datos de 'progresivas'
        // return $this->db->table('progresivas')->where('id_proyec', $id_proyecto)->delete();
        log_message('info', "Eliminando Progresivas para el proyecto ID: {$id_proyecto} (lógica pendiente)");
        return true; // Placeholder
    }

    /**
     * Simula la función 'existe_grafico_id_proyecto' de CI3.
     * Verifica si existen datos gráficos para un proyecto específico.
     *
     * @param int $id_proyecto El ID del proyecto.
     * @return bool Verdadero si existen datos gráficos, falso en caso contrario.
     */
    public function existeGraficoIdProyecto(int $id_proyecto): bool
    {
        // **IMPORTANTE**: Implementa la lógica real para verificar la existencia de datos gráficos.
        // Ejemplo:
        // $count = $this->db->table('franja_dominio_pol')->where('id_proyec', $id_proyecto)->countAllResults();
        // return $count > 0;
        log_message('info', "Verificando existencia de gráficos para el proyecto ID: {$id_proyecto} (lógica pendiente)");
        return false; // Placeholder: asume que no existen por defecto
    }

    /**
     * Simula la función 'actualizar_shapes_proyecto' de CI3.
     * Actualiza los shapes de un proyecto en la base de datos.
     *
     * @param int $id_proyecto El ID del proyecto.
     * @param int $id_epsg El código EPSG.
     * @return int Se asume que devuelve un entero como el original (0 para éxito, 2 o 4 para error).
     */
    public function actualizarShapesProyecto(int $id_proyecto, int $id_epsg): int
    {
        // **IMPORTANTE**: Implementa la lógica real para actualizar los shapes.
        // Esto implicaría operaciones de base de datos después de la importación.
        log_message('info', "Actualizando shapes para el proyecto ID: {$id_proyecto} con EPSG: {$id_epsg} (lógica pendiente)");
        return 0; // Placeholder: asume éxito
    }

    /**
     * Simula la función 'actualizar_shapes_progre' de CI3.
     * Actualiza los shapes progresivos de un proyecto en la base de datos.
     *
     * @param int $id_proyecto El ID del proyecto.
     * @param int $id_epsg El código EPSG.
     * @return int Se asume que devuelve un entero como el original.
     */
    public function actualizarShapesProgre(int $id_proyecto, int $id_epsg): int
    {
        // **IMPORTANTE**: Implementa la lógica real para actualizar los shapes progresivos.
        log_message('info', "Actualizando shapes progresivas para el proyecto ID: {$id_proyecto} con EPSG: {$id_epsg} (lógica pendiente)");
        return 0; // Placeholder
    }

    /**
     * Simula la función 'mensaje_error' de CI3.
     * Recupera un mensaje de error específico para un proyecto.
     *
     * @param int $id_proyecto El ID del proyecto.
     * @return string El mensaje de error.
     */
    public function mensajeError(int $id_proyecto): string
    {
        // **IMPORTANTE**: Implementa la lógica real para obtener el mensaje de error.
        // Podría ser una consulta a una tabla de logs o errores.
        log_message('info', "Recuperando mensaje de error para el proyecto ID: {$id_proyecto} (lógica pendiente)");
        return "Error desconocido al procesar shapes para el proyecto ID: {$id_proyecto}. Por favor, revise los logs."; // Placeholder
    }
}