<?php

namespace App\Models;

use CodeIgniter\Model;

class ManzanaModel extends Model
{
    protected $table         = 'bdgeo.manzanas';
    protected $primaryKey    = 'gid';
    protected $returnType    = 'array';
    protected $useTimestamps = false;

    protected $allowedFields = [
    'cod_mza',
    'sup_area',
    'distritos',
    'observacion'
    ];

    /**
     * Aplica filtros personalizados y retorna QueryBuilder para usar paginación manual
     */

public function getFilteredData(?int $limit = null, int $offset = 0, array $filters = [])
{
    $builder = $this->db->table($this->table);

    foreach ($filters as $campo => $valor) {
        if (!empty($valor) && in_array($campo, $this->allowedFields)) {
            if ($campo === 'sup_area') {
                // Para sup_area (campo numérico), aplicar comparación exacta o rango
                if (is_numeric($valor)) {
                    $builder->where($campo, (float)$valor);
                }
            } else {
                // Para campos texto usar ILIKE con LOWER
                $builder->where("LOWER($campo) ILIKE '%" . strtolower($valor) . "%'");
            }
        }
    }

    $builder->orderBy('gid', 'ASC');

    if ($limit !== null) {
        return $builder->get($limit, $offset);
    }

    return $builder->get();
}


public function getFilteredCount($filters = [])
{
    $builder = $this->db->table($this->table);

    if (!empty($filters['cod_mza'])) {
        $builder->where("LOWER(cod_mza) ILIKE '%" . strtolower($filters['cod_mza']) . "%'");
    }

    if (!empty($filters['sup_area'])) {
        if (is_numeric($filters['sup_area'])) {
            $builder->where('sup_area', (float) $filters['sup_area']);
        }
    }

    if (!empty($filters['distritos'])) {
        $builder->where("LOWER(distritos) ILIKE '%" . strtolower($filters['distritos']) . "%'");
    }

    if (!empty($filters['observacion'])) {
        $builder->where("LOWER(observacion) ILIKE '%" . strtolower($filters['observacion']) . "%'");
    }

    return $builder->countAllResults();
}

}