// app/Models/MedidorArchivoModel.php

<?php

namespace App\Models;

use CodeIgniter\Model;
use App\Libraries\Auditoria;

class MedidorArchivoModel extends Model
{
    // Nombre de la tabla en tu base de datos
    protected $table      = 'medidor_archivos';

    // Clave primaria de la tabla
    protected $primaryKey = 'id';

    // Tipo de retorno para los resultados (object, array)
    protected $returnType = 'object'; // Puedes usar 'array' si lo prefieres

    // Habilitar o deshabilitar timestamps (created_at, updated_at)
    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at'; // Para Soft Deletes

    // Habilitar o deshabilitar Soft Deletes (marcar como borrado en lugar de borrar físicamente)
    protected $useSoftDeletes = false; // Cambia a 'true' si quieres usar Soft Deletes

    // Campos que se pueden rellenar masivamente (columnas de la tabla)
    // Es crucial definir estos campos para evitar la asignación masiva de campos no deseados
    protected $allowedFields = [
        'nombre_original',
        'nombre_guardado',
        'ruta_archivo',
        'tipo_mime',
        'tamano',
        'carpeta_cliente', // El nombre de la carpeta del cliente
        'usuario_id',     // ID del usuario que subió el archivo (si tienes gestión de usuarios)
        // Puedes añadir más campos según tus necesidades, como 'estado_importacion', etc.
    ];

    // Reglas de validación para insertar/actualizar datos
    protected $validationRules = [
        'nombre_original' => 'required|max_length[255]',
        'nombre_guardado' => 'required|max_length[255]',
        'ruta_archivo'    => 'required|max_length[512]',
        'tipo_mime'       => 'required|max_length[100]',
        'tamano'          => 'required|integer',
        'carpeta_cliente' => 'required|max_length[100]',
        'usuario_id'      => 'permit_empty|integer', // Permite vacío si no es obligatorio
    ];

    protected $validationMessages = [
        'nombre_original' => [
            'required'   => 'El nombre original del archivo es obligatorio.',
            'max_length' => 'El nombre original es demasiado largo.',
        ],
        'ruta_archivo' => [
            'required'   => 'La ruta del archivo es obligatoria.',
            'max_length' => 'La ruta del archivo es demasiado larga.',
        ],
        // ... puedes añadir más mensajes personalizados para otras reglas
    ];

    // Opciones de callback antes/después de ciertas operaciones (ej: antes de insertar)
    protected $beforeInsert = [];
    protected $afterInsert  = [];
    protected $beforeUpdate = [];
    protected $afterUpdate  = [];
    protected $beforeFind   = [];
    protected $afterFind    = [];
    protected $beforeDelete = [];
    protected $afterDelete  = [];

    // Puedes añadir métodos personalizados para interactuar con la base de datos
    // Por ejemplo, para obtener archivos por carpeta de cliente
    public function getFilesByCustomerFolder($folderName)
    {
        return $this->where('carpeta_cliente', $folderName)->findAll();
    }
}