<?php

namespace App\Models;

use CodeIgniter\Model;
use App\Libraries\Auditoria;

class MedidoresModel extends Model
{
    protected $table = 'bdgeo.medidores';
    protected $primaryKey = 'gid';
    protected $allowedFields = [
        'cod_fijo', 'cod_usuario', 'nombres', 'apellidos', 'direccion', 'num_casa', 'nit_ci', 'tipo_vivienda', 'categoria', 'numero_medidor', 'marca_medidor', 'diam_acometida', 'mat_tub_acometida',
        'ubicacion', 'distrito', 'otb', 'zona_abast', 'zona_cod_comercial', 'lectura_inicial', 'fecha_lect_inicial',
        'lectura_final', 'fecha_lect_final', 'inst_con_liberacion', 'usu_funcionario',
        'fecha_instalacion', 'estado_registro', 'tipo_lectura', 'control_datos_crc',
        'observaciones', 'foto_inicial', 'este', 'norte', 'cota', 'municipio', 'provincia', 'departamento'
    
    ];


    // ✔ Devuelve los datos filtrados con orden por gid


    public function getFilteredData(?int $limit = null, int $offset = 0, array $filters = [])
    {
        $builder = $this->db->table($this->table);
    
        // Filtro por campos permitidos
        foreach ($filters as $campo => $valor) {
            if (!empty($valor) && in_array($campo, $this->allowedFields)) {
                $builder->where("LOWER($campo) ILIKE '%" . strtolower($valor) . "%'");
            }
        }
    
        $builder->orderBy('gid', 'ASC');
    
        // Si se define límite, se aplica paginación
        if ($limit !== null) {
            return $builder->get($limit, $offset);
        }
    
        // Si no hay límite, obtener todos los resultados
        return $builder->get();
    }




   // ✔ Devuelve el número total de resultados filtrados
    public function getFilteredCount($filters = [])
    {
        $builder = $this->db->table($this->table);

        if (!empty($filters['cod_fijo'])) {
            $builder->where("LOWER(cod_fijo) ILIKE '%" . strtolower($filters['cod_fijo']) . "%'");
        }
        if (!empty($filters['cod_usuario'])) {
            $builder->where("LOWER(cod_usuario) ILIKE '%" . strtolower($filters['cod_usuario']) . "%'");
        }
        if (!empty($filters['nombres'])) {
            $builder->where("LOWER(nombres) ILIKE '%" . strtolower($filters['nombres']) . "%'");
        }
    
        if (!empty($filters['apellidos'])) {
            $builder->where("LOWER(apellidos) ILIKE '%" . strtolower($filters['apellidos']) . "%'");
        }
        if (!empty($filters['direccion'])) {
            $builder->where("LOWER(direccion) ILIKE '%" . strtolower($filters['direccion']) . "%'");
        }
        if (!empty($filters['nit_ci'])) {
            $builder->where("LOWER(nit_ci) ILIKE '%" . strtolower($filters['nit_ci']) . "%'");
        }
        if (!empty($filters['numero_medidor'])) {
            $builder->where("LOWER(numero_medidor) ILIKE '%" . strtolower($filters['numero_medidor']) . "%'");
        }
        return $builder->countAllResults();
    }

    public function insert_auditor($data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->insert($data);
        $db->transCommit();
        return true;
    } 
    
    public function update_auditor($id, $data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->update($id, $data);
        $db->transCommit();
        return true;
    } 
    
    public function delete_auditor($id)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->delete($id);
        $db->transCommit();
        return true;
    } 

}
