<?php

namespace App\Models;

use CodeIgniter\Model;
use App\Libraries\Auditoria;

class PredioModel extends Model
{
    protected $table            = 'bdgeo.predios';
    protected $primaryKey       = 'gid';
    protected $returnType       = 'array';
    protected $useTimestamps    = false;

    protected $allowedFields    = [
        'cod_parcel',
        'cod_ubicac',
        'cod_fijo',
        'tipo_predi',
        'latitud',
        'longitud',
        'calle',
        'nombres',
        'apellidos'
    ];

    /**
     * Aplica filtros personalizados para búsqueda
     */
    public function getFilteredData($search = [], $perPage = 10)
{
    $camposTexto = ['cod_parcel', 'cod_ubicac', 'cod_fijo', 'tipo_predi', 'calle', 'nombres', 'apellidos'];
    $camposNumericos = ['latitud', 'longitud'];

    $builder = $this->builder();

    foreach ($search as $campo => $valor) {
        if (!empty($valor)) {
            if (in_array($campo, $camposTexto)) {
                $builder->like($campo, $valor);
            } elseif (in_array($campo, $camposNumericos)) {
                $builder->where($campo, $valor);
            }
        }
    }

    // Usa el builder filtrado para la consulta
    $this->builder = $builder;

    // Ahora llama paginate() en $this (modelo), no en $builder
    return $this->paginate($perPage);
}

    public function getFilteredCount($search = [])
    {
        $camposTexto = ['cod_parcel', 'cod_ubicac', 'cod_fijo', 'tipo_predi', 'calle', 'nombres', 'apellidos'];
        $camposNumericos = ['latitud', 'longitud'];

        $builder = $this->builder();

        foreach ($search as $campo => $valor) {
            if (!empty($valor)) {
                if (in_array($campo, $camposTexto)) {
                    $builder->like($campo, $valor);
                } elseif (in_array($campo, $camposNumericos)) {
                    $builder->where($campo, $valor);
                }
            }
        }

        return $builder->countAllResults();
    }
    
    public function insert_auditor($data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->insert($data);
        $db->transCommit();
        return true;
    } 
    
    public function update_auditor($id, $data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->update($id, $data);
        $db->transCommit();
        return true;
    } 
    
    public function delete_auditor($id)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->delete($id);
        $db->transCommit();
        return true;
    }     
}