<?php

namespace App\Models;

use CodeIgniter\Model;
use App\Libraries\Auditoria;

class UserModel extends Model
{
    protected $table            = 'admin.users';
    protected $primaryKey       = 'id';
    protected $returnType       = 'array';
    //protected $useTimestamps    = true
    protected $useTimestamps    = false;    
    protected $createdField     = 'created_at';  
 
    protected $allowedFields    = [
        'username',
        'password_hash',
        'email',
        'active',
        'estado',
        'nombre',
        'apellido',
    ];

    public function buscar($filtros)
    {
        foreach ($filtros as $campo => $valor) {
            if (!empty($valor)) {
                $this->like("LOWER($campo)", strtolower($valor));
            }
        }

        return $this;
    }
    
    public function getUserByUsername($username)
    {
        return $this->where('username', $username)->first();
    }

    public function getGroupId($userId)
    {
        $builder = $this->db->table('admin.user_group');
        $builder->select('group_id');
        $builder->where('user_id', $userId);
        $query = $builder->get();
        $result = $query->getRowArray();
        return $result['group_id'] ?? null;
    }

	public function buscarUsuarioMail($email) 
    {
    	$db = db_connect();
        $builder = $db->table($this->table)->where('email',$email)->where('l_estado', 'A');
    	$resultado = $builder->get();
        return $resultado->getResult() ? $resultado->getResult()[0] : false;
    }

	public function buscarUsuarioUsuario($usuario) 
    {
    	$db = db_connect();
        $builder = $db->table($this->table)->where('username',$usuario)->where('l_estado', 'A');
    	$resultado = $builder->get();
        return $resultado->getResult() ? $resultado->getResult()[0] : false;
    }
    
  public function insert_auditor($data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->insert($data);
        $db->transCommit();
        return true;
    } 
    
    public function update_auditor($id, $data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->update($id, $data);
        $db->transCommit();
        return true;
    } 
    
    public function delete_auditor($id)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->delete($id);
        $db->transCommit();
        return true;
    } 
    
}



