<?php namespace App\Models;

use CodeIgniter\Model;
use App\Libraries\Auditoria;

class UsuarioModel extends Model
{
    protected $table      = 'admin.usuarios'; // Define la tabla con su esquema
    protected $primaryKey = 'id_usuario';

    protected $allowedFields = [
        'nombre', 'apellido', 'email', 'foto', 'usuario', 
        'f_nacimiento', 'id_grupo', 'id_cliente', 'l_estado', 
        'clave', 'clavesald'
    ];

    public function getUsuario($id)
    {
        return $this->where('id_usuario', $id)->first();
    }


    // Configuración de la paginación
    public function getUsuarios($limit, $offset, $filters = [])
    {
        $builder = $this->db->table($this->table);

        // Aplica los filtros si existen
        if (!empty($filters['nombre'])) {
            $builder->like('LOWER(nombre)', strtolower($filters['nombre']));
        }
        if (!empty($filters['apellido'])) {
            $builder->like('LOWER(apellido)', strtolower($filters['apellido']));
        }
        if (!empty($filters['email'])) {
            $builder->like('LOWER(email)', strtolower($filters['email']));
        }
        if (!empty($filters['id_grupo'])) {
            $builder->where('LOWER(id_grupo)', strtolower($filters['id_grupo']));
        }
        if (!empty($filters['id_cliente'])) {
            $builder->where('LOWER(id_cliente)', strtolower($filters['id_cliente']));
        }

        // Ordenar por defecto por nombre y luego paginar
        $builder->orderBy('nombre', 'ASC');
        $query = $builder->get($limit, $offset);
        
        return $query->getResult();
    }

    // Método para obtener la cantidad de resultados filtrados
    public function getCount($filters = [])
    {
        $builder = $this->db->table($this->table);

        if (!empty($filters['nombre'])) {
            $builder->like('nombre', $filters['nombre']);
        }
        if (!empty($filters['apellido'])) {
            $builder->like('apellido', $filters['apellido']);
        }
        if (!empty($filters['email'])) {
            $builder->like('email', $filters['email']);
        }
        if (!empty($filters['id_grupo'])) {
            $builder->where('id_grupo', $filters['id_grupo']);
        }
        if (!empty($filters['id_cliente'])) {
            $builder->where('id_cliente', $filters['id_cliente']);
        }

        return $builder->countAllResults();
    }
    
    public function insert_auditor($data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->insert($data);
        $db->transCommit();
        return true;
    } 
    
    public function update_auditor($id, $data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->update($id, $data);
        $db->transCommit();
        return true;
    } 
    
    public function delete_auditor($id)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->delete($id);
        $db->transCommit();
        return true;
    } 
    
}



