<?php

namespace App\Models;

use CodeIgniter\Model;

use App\Libraries\Auditoria;

class ValvulasModel extends Model
{
    protected $table = 'bdgeo.valvulas';
    protected $primaryKey = 'gid';
    protected $allowedFields = [
        'geom', 'norte', 'este', 'elevacion',
        'diametro', 'id_valvula', 'tipo', 'funcion', 'edad', 'estado',
        'tapa', 'responsable', 'ubicacion', 'departamento', 'provincia',
        'municipio', 'distrito', 'otb', 'descripcion'
    ];

    public function getFilteredData($limit, $offset, $filters = [])
    {
        $builder = $this->db->table($this->table);

        if (!empty($filters['id_valvula'])) {
            $builder->where("LOWER(id_valvula) ILIKE '%" . strtolower($filters['id_valvula']) . "%'");
        }
        if (!empty($filters['ubicacion'])) {
            $builder->where("LOWER(ubicacion) ILIKE '%" . strtolower($filters['ubicacion']) . "%'");
        }
        if (!empty($filters['otb'])) {
            $builder->where("LOWER(otb) ILIKE '%" . strtolower($filters['otb']) . "%'");
        }
        if (!empty($filters['distrito'])) {
            $builder->where("LOWER(distrito) ILIKE '%" . strtolower($filters['distrito']) . "%'");
        }

        $builder->orderBy('gid', 'ASC');

        return $builder->get($limit, $offset)->getResultArray();
    }

    public function getFilteredCount($filters = [])
    {
        $builder = $this->db->table($this->table);

        if (!empty($filters['id_valvula'])) {
            $builder->where("LOWER(id_valvula) ILIKE '%" . strtolower($filters['id_valvula']) . "%'");
        }
        if (!empty($filters['ubicacion'])) {
            $builder->where("LOWER(ubicacion) ILIKE '%" . strtolower($filters['ubicacion']) . "%'");
        }
        if (!empty($filters['otb'])) {
            $builder->where("LOWER(otb) ILIKE '%" . strtolower($filters['otb']) . "%'");
        }
        if (!empty($filters['distrito'])) {
            $builder->where("LOWER(distrito) ILIKE '%" . strtolower($filters['distrito']) . "%'");
        }

        return $builder->countAllResults();
    }
    
    public function insert_auditor($data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->insert($data);
        $db->transCommit();
        return true;
    } 
    
    public function update_auditor($id, $data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->update($id, $data);
        $db->transCommit();
        return true;
    } 
    
    public function delete_auditor($id)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->delete($id);
        $db->transCommit();
        return true;
    }     
}



