<?php
function render_input_fields(array $campos, array $datos = [], array $tipos_especiales = [], $col = 'col-md-3') {
    foreach ($campos as $campo) {
        $type = $tipos_especiales[$campo] ?? 'text';
        $label = ucfirst(str_replace('_', ' ', $campo));
        $valor = esc($datos[$campo] ?? '');

        echo '<div class="' . $col . '">';
        echo '<label class="form-label fw-bold text-sm" style="color: #000;">' . $label . '</label>';
        echo '<input type="' . $type . '" class="form-control form-control-sm" name="' . $campo . '" value="' . $valor . '">';
        echo '</div>';
    }
}
?>


<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">


<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
    /* Botones de acción */
    .acciones a {
        color: #2d5a86;
        margin-right: 10px;
        font-size: 1.1rem;
        transition: color 0.3s ease, background-color 0.3s ease;
        padding: 6px;
        border-radius: 5px;
        text-decoration: none;
    }
    .acciones a:hover {
        background-color: rgba(77, 130, 188, 0.1);
        color: #16A6BA;
    }
    .acciones a.eliminar:hover {
        background-color: rgba(255, 0, 0, 0.1);
        color: darkred;
    }

    /* Cabecera de la tabla */
    thead {
        background-color: #2d5a86;
        color: white;
    }
    thead th {
        text-align: center !important;
        vertical-align: middle !important;
    }

    /* Celdas del cuerpo */
    tbody td {
        text-align: center;
        vertical-align: middle;
    }
    tbody td.acciones {
        text-align: left;
    }

    /* Botones */
    .btn-buscar,
    .btn-crear {
        background-color: #2d5a86;
        color: white;
    }
    .btn-buscar:hover,
    .btn-crear:hover {
        background-color: #16A6BA;
        color: white;
    }

    /* Inputs al enfocar */
    input.form-control:focus {
        border: 2px solid #16A6BA;
        box-shadow: 0 0 6px rgba(22, 166, 186, 0.5);
        outline: none;
    }
</style>

<div class="container mt-3">
    <h4 class="text-center fw-bold mb-4" style="color: #2d5a86;">Editar Cámara</h4>

    <form action="<?= base_url('camaras/update/' . $camara['gid']) ?>" method="post">

        <!-- Grupo 1: Código -->
        <fieldset class="border p-3 mb-3">
            <legend class="w-auto px-3 fw-bold fs-5" style="color: #2d5a86;">Código</legend>
            <div class="row g-2 align-items-center">
                <div class="col-auto">
                    <label for="codigo" class="form-label fw-bold text-sm mb-0" style="color: #000;">Código <span class="text-danger">*</span>
                    </label>
                </div>
                <div class="col-auto">
                    <input type="text" id="codigo" class="form-control form-control-sm" name="codigo" value="<?= esc($camara['codigo']) ?>" style="width: 150px;" required>
                </div>
            </div>
        </fieldset>

        <!-- Grupo 2: Ubicación -->
        <fieldset class="border p-3 mb-3">
            <legend class="w-auto px-3 fw-bold fs-5" style="color: #2d5a86;">Ubicación</legend>
            <div class="row g-3">
                <?php
                render_input_fields(['otb', 'distrito'], $camara, [], 'col-md-3');
                render_input_fields(['nombre_calle'], $camara, [], 'col-md-6');
                render_input_fields(['ubicacion'], $camara, [], 'col-md-3');
                render_input_fields(['nombre_cuenca'], $camara, [], 'col-md-2');
                render_input_fields(['este'], $camara, [], 'col-md-2');
                render_input_fields(['norte'], $camara, [], 'col-md-2');
                ?>
            </div>
        </fieldset>

        <!-- Grupo 3: Características -->
        <fieldset class="border p-3 mb-3">
            <legend class="w-auto px-3 fw-bold fs-5" style="color: #2d5a86;">Características</legend>
            <div class="row g-3">
                <?php
                $caracteristicas = [
                    'altura', 'diametro', 'forma', 'cota', 'caida', 'estado',
                    'numero_cruce', 'material_tapa', 'codigo_activos_fijos',
                    'fecha_instalacion', 'fecha_habilitacion', 'valor_instalacion'
                ];
                $tipos_fecha = [
                    'fecha_instalacion' => 'date',
                    'fecha_habilitacion' => 'date'
                ];
                render_input_fields($caracteristicas, $camara, $tipos_fecha, 'col-md-3');
                ?>
            </div>
        </fieldset>

        <!-- Grupo 4: Otros -->
        <fieldset class="border p-3 mb-3">
            <legend class="w-auto px-3 fw-bold fs-5" style="color: #2d5a86;">Otros</legend>
            <div class="row g-3">
                <?php
                $otros = [
                    'tipo_inversion', 'nombre_proyecto', 'empresa_responsable',
                    'supervisor', 'encargado_levantamiento', 'responsable_catastro'
                ];
                render_input_fields($otros, $camara, [], 'col-md-4');
                ?>
            </div>
        </fieldset>

        <!-- Grupo 5: Observaciones -->
        <fieldset class="border p-3 mb-4">
            <legend class="w-auto px-3 fw-bold fs-5" style="color: #2d5a86;">Observaciones</legend>
            <div class="row">
                <div class="col-md-12">
                    <label class="form-label fw-bold text-sm" style="color: #000;">Observaciones</label>
                    <textarea name="observaciones" rows="3" class="form-control form-control-sm"><?= esc($camara['observaciones']) ?></textarea>
                </div>
            </div>
        </fieldset>

        <!-- Botones -->
        <div class="text-center mb-5">
            <button type="submit" class="btn btn-sm px-4" style="background-color: #2d5a86; color: white;">Actualizar</button>
            <a href="<?= base_url('camaras') ?>" class="btn btn-sm btn-secondary px-4 ms-2">Cancelar</a>
        </div>

    </form>
</div>
<?= $this->endSection(); ?>










