<?php
function render_input_fields(array $campos, array $datos = [], array $tipos_especiales = [], $col = 'col-md-3') {
    foreach ($campos as $campo) {
        $type = $tipos_especiales[$campo] ?? 'text';
        $label = ucfirst(str_replace('_', ' ', $campo));
        $valor = esc($datos[$campo] ?? '');

        echo '<div class="' . $col . '">';
        echo '<label class="form-label fw-bold text-sm" style="color: #000;">' . $label . '</label>';
        echo '<input type="' . $type . '" class="form-control form-control-sm" name="' . $campo . '" value="' . $valor . '">';
        echo '</div>';
    }
}
?>


<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">


<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
    /* Botones de acción */
    .acciones a {
        color: #2d5a86;
        margin-right: 10px;
        font-size: 1.1rem;
        transition: color 0.3s ease, background-color 0.3s ease;
        padding: 6px;
        border-radius: 5px;
        text-decoration: none;
    }
    .acciones a:hover {
        background-color: rgba(77, 130, 188, 0.1);
        color: #16A6BA;
    }
    .acciones a.eliminar:hover {
        background-color: rgba(255, 0, 0, 0.1);
        color: darkred;
    }

    /* Cabecera de la tabla */
    thead {
        background-color: #2d5a86;
        color: white;
    }
    thead th {
        text-align: center !important;
        vertical-align: middle !important;
    }

    /* Celdas del cuerpo */
    tbody td {
        text-align: center;
        vertical-align: middle;
    }
    tbody td.acciones {
        text-align: left;
    }

    /* Botones */
    .btn-buscar,
    .btn-crear {
        background-color: #2d5a86;
        color: white;
    }
    .btn-buscar:hover,
    .btn-crear:hover {
        background-color: #16A6BA;
        color: white;
    }

    /* Inputs al enfocar */
    input.form-control:focus {
        border: 2px solid #16A6BA;
        box-shadow: 0 0 6px rgba(22, 166, 186, 0.5);
        outline: none;
    }
</style>

<div class="container mt-3">
    <h4 class="text-center fw-bold mb-4" style="color: #2d5a86;">Editar Cámara</h4>

    <form action="<?= base_url('camaras/update/' . $camara['gid']) ?>" method="post" enctype="multipart/form-data">
        <!-- Grupo 1: Código -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold text-primary">Código</legend>
            <div class="row">
                <div class="col-md-4">
                    <label for="codigo" class="form-label fw-bold">Código <span class="text-danger">*</span></label>
                    <input type="text" name="codigo" id="codigo" value="<?= esc($camara['codigo']) ?>" class="form-control form-control-sm" required>
                </div>
            </div>
        </fieldset>
        
        <!-- Grupo 2: Ubicación -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold text-primary">Ubicación</legend>
            <div class="row g-2">
                <?php
                $camposUbicacion = [
                    'otb' => 'OTB',
                    'distrito' => 'Distrito',
                    'nombre_calle' => 'Nombre Calle',
                    'ubicacion' => 'Ubicación',
                    'nom_cuenca' => 'Nombre Cuenca',
                    'este' => 'Este',
                    'norte' => 'Norte'
                ];
                foreach ($camposUbicacion as $campo => $label): ?>
                    <div class="col-md-3">
                        <label for="<?= $campo ?>" class="form-label fw-bold"><?= $label ?>
                            <?php if ($campo === 'ubicacion'): ?>
                                <span class="text-danger">*</span>
                            <?php endif; ?>
                        </label>
                        <?php if ($campo === 'ubicacion'): ?>
                            <select name="ubicacion" id="ubicacion" class="form-control form-control-sm" required>
                                <option value="">-- Seleccione --</option>
                                <?php foreach ($ubiCamara as $opcion): ?>
                                    <option value="<?= esc($opcion['concepto']) ?>" <?= $camara['ubicacion'] === $opcion['concepto'] ? 'selected' : '' ?>><?= esc($opcion['nombre']) ?></option>
                                <?php endforeach; ?>
                            </select>
                        <?php else: ?>
                        <input type="text" name="<?= $campo ?>" id="<?= $campo ?>" value="<?= esc($camara[$campo] ?? '') ?>" class="form-control form-control-sm">
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </fieldset>
        
        <!-- Grupo 3: Características -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold text-primary">Características</legend>
            <div class="row g-2">
                <?php
                $camposCaracteristicas = [
                    'altura' => 'Altura',
                    'diametro' => 'Diámetro',
                    'forma' => 'Forma',
                    'cota' => 'Cota',
                    'caida' => 'Caída',
                    'estado' => 'Estado',
                    'numero_cruce' => 'Número Cruce',
                    'material_tapa' => 'Material Tapa',
                    'cod_activos_fijos' => 'Código Activos Fijos',
                    'fecha_instalacion' => 'Fecha Instalación',
                    'fecha_habilitacion' => 'Fecha Habilitación',
                    'valor_instalacion' => 'Valor Instalación'
                ];
                $tiposEspeciales = [
                    'fecha_instalacion' => 'date',
                    'fecha_habilitacion' => 'date'
                ];
                $camposRequeridos = ['fecha_instalacion', 'diametro', 'estado', 'forma', 'material_tapa', 'cod_activos_fijos'];
                foreach ($camposCaracteristicas as $campo => $label): ?>
                    <div class="col-md-3">
                        <label for="<?= $campo ?>" class="form-label fw-bold"><?= $label ?>
                            <?php if (in_array($campo, $camposRequeridos)): ?>
                                <span class="text-danger">*</span>
                            <?php endif; ?>
                        </label>
                    <?php if ($campo === 'estado'): ?>
                        <select name="estado" id="estado" class="form-control form-control-sm" <?= in_array('estado', $camposRequeridos) ? 'required' : '' ?>>
                            <option value="">-- Seleccione --</option>
                            <?php foreach ($estadoCamara as $opcion): ?>
                                <option value="<?= esc($opcion['concepto']) ?>" <?= $camara['estado'] === $opcion['concepto'] ? 'selected' : '' ?>><?= esc($opcion['nombre']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    <?php else: ?>
                        <?php if ($campo === 'forma'): ?>
                            <select name="forma" id="forma" class="form-control form-control-sm" <?= in_array('forma', $camposRequeridos) ? 'required' : '' ?>>
                                <option value="">-- Seleccione --</option>
                                <?php foreach ($formaCamara as $opcion): ?>
                                    <option value="<?= esc($opcion['concepto']) ?>" <?= $camara['forma'] === $opcion['concepto'] ? 'selected' : '' ?>><?= esc($opcion['nombre']) ?></option>
                                <?php endforeach; ?>
                            </select>
                        <?php else: ?>
                            <?php if ($campo === 'caida'): ?>
                                <select name="caida" id="caida" class="form-control form-control-sm">
                                    <option value="">-- Seleccione --</option>
                                    <?php foreach ($caidaCamara as $opcion): ?>
                                        <option value="<?= esc($opcion['concepto']) ?>" <?= $camara['caida'] === $opcion['concepto'] ? 'selected' : '' ?>><?= esc($opcion['nombre']) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            <?php else: ?>
                                
                        <input type="<?= $tiposEspeciales[$campo] ?? 'text' ?>" name="<?= $campo ?>" id="<?= $campo ?>" value="<?= esc($camara[$campo] ?? '') ?>" class="form-control form-control-sm" <?= in_array($campo, $camposRequeridos) ? 'required' : '' ?>>
                    
                            <?php endif; ?>
                        <?php endif; ?>                        
                    <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </fieldset>
        
        <!-- Grupo 4: Otros -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold text-primary">Otros</legend>
            <div class="row g-2">
                <?php
                $camposOtros = [
                    'tipo_inversion' => 'Tipo Inversión',
                    'nom_proyecto' => 'Nombre Proyecto',
                    'emp_responsable' => 'Empresa Responsable',
                    'supervisor' => 'Supervisor',
                    'encargado_lev' => 'Encargado Levantamiento',
                    'resp_catastro' => 'Responsable Catastro'
                ];
                foreach ($camposOtros as $campo => $label): ?>
                    <div class="col-md-4">
                        <label for="<?= $campo ?>" class="form-label fw-bold"><?= $label ?>
                        <?php if ($campo === 'encargado_lev'): ?>
                            <span class="text-danger">*</span>
                        <?php endif; ?>
                        </label>
                        <input type="text" name="<?= $campo ?>" id="<?= $campo ?>" value="<?= esc($camara[$campo] ?? '') ?>" class="form-control form-control-sm" <?php if ($campo === 'encargado_lev'): ?> required <?php endif; ?>>
                    </div>
                <?php endforeach; ?>
            </div>
        </fieldset>
        
        <!-- Grupo 5: Observaciones -->
        <fieldset class="border p-2 mb-4">
            <legend class="w-auto px-2 fw-bold text-primary">Observaciones</legend>
            <div class="row">
                <div class="col-md-12">
                    <label for="observaciones" class="form-label fw-bold">Observaciones</label>
                    <textarea name="observaciones" id="observaciones" rows="3" class="form-control form-control-sm"><?= esc($camara['observaciones']) ?></textarea>
                </div>
            </div>
        </fieldset>
        
        <!-- Botones -->
        <div class="text-center mb-5">
            <button type="submit" class="btn btn-primary px-4">Actualizar</button>
            <a href="<?= base_url('camaras') ?>" class="btn btn-secondary px-4 ms-2">Cancelar</a>
        </div>


      

    </form>
</div>
<?= $this->endSection(); ?>










