<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<div class="container mt-3">
    <h2 class="fw-bold text-center mb-4" style="color: #2d5a86; font-size: 1.9rem;">
        Registrar Medidor
    </h2>

    <form action="<?= base_url('medidores/store') ?>" method="post" enctype="multipart/form-data">
    

        <!-- Grupo 1: Código -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold text-primary">Código</legend>
            <div class="row">
                <div class="col-md-4">
                    <label for="cod_fijo" class="form-label fw-bold">
                        Código Fijo <span class="text-danger">*</span>
                    </label>
                    <input type="text" name="cod_fijo" id="cod_fijo" class="form-control form-control-sm" required>
                </div>
            </div>
        </fieldset>


        <!-- Grupo 2: Usuario -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold text-primary">Usuario</legend>
            <div class="row g-2">
                <?php
                $campos = [
                    'cod_usuario' => 'Código Usuario',
                    'nombres' => 'Nombres',
                    'apellidos' => 'Apellidos',
                    'direccion' => 'Dirección',
                    'num_casa' => 'Número Casa',
                    'nit_ci' => 'NIT/CI',
                    'tipo_vivienda' => 'Tipo Vivienda',
                    'categoria' => 'Categoría'
                ];
        
                $camposRequeridos = ['cod_usuario', 'nombres', 'apellidos', 'direccion', 'num_casa', 'nit_ci'];
                foreach ($campos as $campo => $label): ?>
                    <div class="col-md-3">
                        <label for="<?= $campo ?>" class="form-label fw-bold">
                            <?= $label ?>
                            <?php if (in_array($campo, $camposRequeridos)): ?>
                                <span class="text-danger">*</span>
                            <?php endif; ?>
                        </label>
        
                        <?php if ($campo === 'tipo_vivienda'): ?>
                            <select name="tipo_vivienda" id="tipo_vivienda" class="form-control form-control-sm">
                                <option value="">-- Seleccione --</option>
                                <?php foreach ($tipoVivienda as $opcion): ?>
                                    <option value="<?= esc($opcion['concepto']) ?>"><?= esc($opcion['nombre']) ?></option>
                                <?php endforeach; ?>
                            </select>
                        <?php elseif ($campo === 'categoria'): ?>
                            <select name="categoria" id="categoria" class="form-control form-control-sm">
                                <option value="">-- Seleccione --</option>
                                <?php foreach ($categoria as $opcion): ?>
                                    <option value="<?= esc($opcion['concepto']) ?>"><?= esc($opcion['nombre']) ?></option>
                                <?php endforeach; ?>
                            </select>
                        <?php else: ?>
                            <input
                                type="text"
                                name="<?= $campo ?>"
                                id="<?= $campo ?>"
                                class="form-control form-control-sm"
                                <?= in_array($campo, $camposRequeridos) ? 'required' : '' ?>
                            >
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </fieldset>


        <!-- Grupo 3: Acometida -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold text-primary">Acometida</legend>
            <div class="row g-2">
                <?php
                $acometida = [
                    'diam_acometida' => 'Diámetro Acometida',
                    'mat_tub_acometida' => 'Material Tubo',
                    'numero_medidor' => 'Número Medidor',
                    'marca_medidor' => 'Marca Medidor'
                ];
                
                $camposRequeridos = ['diam_acometida', 'mat_tub_acometida', 'numero_medidor', 'marca_medidor'];
                foreach ($acometida as $campo => $label): ?>
                    <div class="col-md-3">
                        <label for="<?= $campo ?>" class="form-label fw-bold">
                            <?= $label ?>
                            <?php if (in_array($campo, $camposRequeridos)): ?>
                                <span class="text-danger">*</span>
                            <?php endif; ?>
                        </label>
                        <input
                            type="text"
                            name="<?= $campo ?>"
                            id="<?= $campo ?>"
                            class="form-control form-control-sm"
                            <?= in_array($campo, $camposRequeridos) ? 'required' : '' ?>
                        >
                    </div>
                <?php endforeach; ?>
            </div>
        </fieldset>

        <!-- Grupo 4: Ubicación -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold text-primary">Ubicación</legend>
            <div class="row g-2">
                <?php
                $ubicacion = [
                    'ubicacion' => 'Ubicación',
                    'este' => 'Este',
                    'norte' => 'Norte',
                    'cota' => 'Cota',
                    'otb' => 'OTB',
                    'distrito' => 'Distrito',
                    'municipio' => 'Municipio',
                    'provincia' => 'Provincia',
                    'departamento' => 'Departamento'
                ];
                foreach ($ubicacion as $campo => $label): ?>
                    <div class="col-md-3">
                        <label for="<?= $campo ?>" class="form-label fw-bold">
                            <?= $label ?>
                            <?php if ($campo === 'ubicacion'): ?>
                                <span class="text-danger">*</span>
                            <?php endif; ?>
                        </label>
        
                        <?php if ($campo === 'ubicacion'): ?>
                            <select name="ubicacion" id="ubicacion" class="form-control form-control-sm" required>
                                <option value="">-- Seleccione --</option>
                                <?php foreach ($ubicacionOpciones as $opcion): ?>
                                    <option value="<?= esc($opcion['concepto']) ?>"><?= esc($opcion['nombre']) ?></option>
                                <?php endforeach; ?>
                            </select>
                        <?php else: ?>
                            <input type="text" name="<?= $campo ?>" id="<?= $campo ?>" class="form-control form-control-sm">
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </fieldset>


        <!-- Grupo 5: Abastecimiento y Lectura -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold text-primary">Abastecimiento y Lectura</legend>
            <div class="row g-2">
                <?php
                $lectura = [
                    'zona_abast' => 'Zona Abastecimiento',
                    'zona_cod_comercial' => 'Código Comercial',
                    'lectura_inicial' => 'Lectura Inicial',
                    'fecha_lect_inicial' => 'Fecha Lectura Inicial',
                    'lectura_final' => 'Lectura Final',
                    'fecha_lect_final' => 'Fecha Lectura Final'
                ];
                foreach ($lectura as $campo => $label): ?>
                    <div class="col-md-4">
                        <label for="<?= $campo ?>" class="form-label fw-bold"><?= $label ?></label>
                        <input type="<?= strpos($campo, 'fecha') !== false ? 'date' : 'text' ?>" name="<?= $campo ?>" id="<?= $campo ?>" class="form-control form-control-sm">
                    </div>
                <?php endforeach; ?>
            </div>
        </fieldset>

        <!-- Grupo 6: Instalación -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold text-primary">Instalación</legend>
            <div class="row g-2">
                <?php
                $instalacion = [
                    'inst_con_liberacion' => 'Inst. Con Liberación',
                    'usu_funcionario' => 'Usuario Funcionario',
                    'fecha_instalacion' => 'Fecha Instalación',
                    'estado_registro' => 'Estado Registro',
                    'tipo_lectura' => 'Tipo Lectura',
                    'control_datos_crc' => 'Control CRC',
                    'foto_inicial' => 'Foto Inicial',
                    
                ];
                foreach ($instalacion as $campo => $label): ?>
                    <div class="col-md-4">
                        <label for="<?= $campo ?>" class="form-label fw-bold"><?= $label ?></label>
                        
                    
                    <?php if ($campo === 'inst_con_liberacion'): ?>
                        <select name="inst_con_liberacion" id="inst_con_liberacion" class="form-control form-control-sm">
                            <option value="">-- Seleccione --</option>
                            <?php foreach ($instLiberacion as $opcion): ?>
                                <option value="<?= esc($opcion['concepto']) ?>"><?= esc($opcion['nombre']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    <?php else: ?>
                        <?php if ($campo === 'usu_funcionario'): ?>
                            <select name="usu_funcionario" id="usu_funcionario" class="form-control form-control-sm">
                                <option value="">-- Seleccione --</option>
                                <?php foreach ($usuarioFuncionario as $opcion): ?>
                                    <option value="<?= esc($opcion['concepto']) ?>"><?= esc($opcion['nombre']) ?></option>
                                <?php endforeach; ?>
                            </select>
                        <?php else: ?>
                            <?php if ($campo === 'estado_registro'): ?>
                                <select name="estado_registro" id="estado_registro" class="form-control form-control-sm">
                                    <option value="">-- Seleccione --</option>
                                    <?php foreach ($estadoRegistro as $opcion): ?>
                                        <option value="<?= esc($opcion['concepto']) ?>"><?= esc($opcion['nombre']) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            <?php else: ?>
                                <?php if ($campo === 'tipo_lectura'): ?>
                                    <select name="tipo_lectura" id="tipo_lectura" class="form-control form-control-sm">
                                        <option value="">-- Seleccione --</option>
                                        <?php foreach ($tipoLectura as $opcion): ?>
                                            <option value="<?= esc($opcion['concepto']) ?>"><?= esc($opcion['nombre']) ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                <?php else: ?>
                        <input type="<?= $campo === 'foto_inicial' ? 'file' : (strpos($campo, 'fecha') !== false ? 'date' : 'text') ?>" name="<?= $campo ?>" id="<?= $campo ?>" class="form-control form-control-sm">   
                                <?php endif; ?>
                            <?php endif; ?>
                        <?php endif; ?>                        
                    <?php endif; ?>
                    </div>
                <?php endforeach; ?>
                
                <!-- Vista previa -->
                <div id="preview_foto">
                    <?php if (!empty($medidor['foto_inicial'])): ?>
                        <img src="<?= base_url('uploads/fotos/' . $medidor['foto_inicial']) ?>" class="img-thumbnail mt-2" width="200">
                        <input type="file" name="foto_inicial" id="foto_inicial" class="form-control form-control-sm mb-2" accept="image/*">
                    <?php endif; ?>
                </div>
            </div>
        </fieldset>

        <!-- Grupo 7: Observaciones -->
        <fieldset class="border p-2 mb-4">
            <legend class="w-auto px-2 fw-bold text-primary">Observaciones</legend>
            <div class="row">
                <div class="col-md-12">
                    <textarea name="observaciones" id="observaciones" rows="3" class="form-control"></textarea>
                </div>
            </div>
        </fieldset>

        <div class="text-center">
            <button type="submit" class="btn btn-primary px-4">Guardar</button>
            <a href="<?= base_url('medidores') ?>" class="btn btn-secondary px-4">Cancelar</a>
        </div>
    </form>
</div>

<script>
document.getElementById('foto_inicial').addEventListener('change', function (event) {
    const file = event.target.files[0];
    const previewContainer = document.getElementById('preview_foto');

    if (file && file.type.startsWith('image/')) {
        const reader = new FileReader();
        reader.onload = function (e) {
            previewContainer.innerHTML = `<img src="${e.target.result}" class="img-thumbnail mt-2" width="200">`;
        };
        reader.readAsDataURL(file);
    } else {
        previewContainer.innerHTML = '';
    }
});
</script>
<?= $this->endSection(); ?>

