<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
    .form-label {
        font-weight: bold;
    }
</style>

<div class="container mt-3">
    <h2 class="fw-bold text-center mb-4" style="color: #2d5a86; font-size: 1.9rem;">
        Detalle del Medidor
    </h2>

    <div class="form">
        <!-- Grupo 1: Código -->
        <fieldset class="border p-2 mb-2">
            <legend class="w-auto px-2 text-primary">Código</legend>
            <div class="row">
                <div class="col-md-4">
                    <label class="form-label">Código Fijo</label>
                    <input type="text" class="form-control form-control-sm" value="<?= esc($medidor['cod_fijo']) ?>" readonly>
                </div>
            </div>
        </fieldset>

        <!-- Grupo 2: Usuario -->
        <fieldset class="border p-2 mb-2">
            <legend class="w-auto px-2 text-primary">Usuario</legend>
            <div class="row g-2">
                <?php
                $usuario = [
                    'cod_usuario' => 'Código Usuario',
                    'nombres' => 'Nombres',
                    'apellidos' => 'Apellidos',
                    'direccion' => 'Dirección',
                    'num_casa' => 'Número Casa',
                    'nit_ci' => 'NIT/CI',
                    'tipo_vivienda' => 'Tipo Vivienda',
                    'categoria' => 'Categoría'
                ];
                foreach ($usuario as $campo => $label): ?>
                    <div class="col-md-3">
                        <label class="form-label"><?= $label ?></label>
                        <input type="text" class="form-control form-control-sm" value="<?= esc($medidor[$campo]) ?>" readonly>
                    </div>
                <?php endforeach; ?>
            </div>
        </fieldset>

        <!-- Grupo 3: Acometida -->
        <fieldset class="border p-2 mb-2">
            <legend class="w-auto px-2 text-primary">Acometida</legend>
            <div class="row g-2">
                <?php
                $acometida = [
                    'diam_acometida' => 'Diámetro Acometida',
                    'mat_tub_acometida' => 'Material Tubo',
                    'numero_medidor' => 'Número Medidor',
                    'marca_medidor' => 'Marca Medidor'
                ];
                foreach ($acometida as $campo => $label): ?>
                    <div class="col-md-3">
                        <label class="form-label"><?= $label ?></label>
                        <input type="text" class="form-control form-control-sm" value="<?= esc($medidor[$campo]) ?>" readonly>
                    </div>
                <?php endforeach; ?>
            </div>
        </fieldset>

        <!-- Grupo 4: Ubicación -->
        <fieldset class="border p-2 mb-2">
            <legend class="w-auto px-2 text-primary">Ubicación</legend>
            <div class="row g-2">
                <?php
                $ubicacion = [
                    'ubicacion' => 'Ubicación',
                    'este' => 'Este',
                    'norte' => 'Norte',
                    'cota' => 'Cota',
                    'otb' => 'OTB',
                    'distrito' => 'Distrito',
                    'municipio' => 'Municipio',
                    'provincia' => 'Provincia',
                    'departamento' => 'Departamento'
                ];
                foreach ($ubicacion as $campo => $label): ?>
                    <div class="col-md-3">
                        <label class="form-label"><?= $label ?></label>
                        <input type="text" class="form-control form-control-sm" value="<?= esc($medidor[$campo]) ?>" readonly>
                    </div>
                <?php endforeach; ?>
            </div>
        </fieldset>

        <!-- Grupo 5: Abastecimiento y Lectura -->
        <fieldset class="border p-2 mb-2">
            <legend class="w-auto px-2 text-primary">Abastecimiento y Lectura</legend>
            <div class="row g-2">
                <?php
                $lectura = [
                    'zona_abast' => 'Zona Abastecimiento',
                    'zona_cod_comercial' => 'Código Comercial',
                    'lectura_inicial' => 'Lectura Inicial',
                    'fecha_lect_inicial' => 'Fecha Lectura Inicial',
                    'lectura_final' => 'Lectura Final',
                    'fecha_lect_final' => 'Fecha Lectura Final'
                ];
                foreach ($lectura as $campo => $label): ?>
                    <div class="col-md-4">
                        <label class="form-label"><?= $label ?></label>
                        <input type="text" class="form-control form-control-sm" value="<?= esc($medidor[$campo]) ?>" readonly>
                    </div>
                <?php endforeach; ?>
            </div>
        </fieldset>

        <!-- Grupo 6: Instalación -->
        <fieldset class="border p-2 mb-2">
            <legend class="w-auto px-2 text-primary">Instalación</legend>
            <div class="row g-2">
                <?php
                $instalacion = [
                    'inst_con_liberacion' => 'Inst. Con Liberación',
                    'usu_funcionario' => 'Usuario Funcionario',
                    'fecha_instalacion' => 'Fecha Instalación',
                    'estado_registro' => 'Estado Registro',
                    'tipo_lectura' => 'Tipo Lectura',
                    'control_datos_crc' => 'Control CRC'
                ];
                foreach ($instalacion as $campo => $label): ?>
                    <div class="col-md-4">
                        <label class="form-label"><?= $label ?></label>
                        <input type="text" class="form-control form-control-sm" value="<?= esc($medidor[$campo]) ?>" readonly>
                    </div>
                <?php endforeach; ?>
                <div class="col-md-4">
                    <label class="form-label">Foto Inicial</label><br>
                    <!-- Contenedor único para la previsualización de la imagen -->
                    <div id="image_preview_wrapper" class="position-relative d-inline-block mt-2 <?= !empty($medidor['foto_inicial']) ? '' : 'd-none' ?>">
                        <img id="preview_imagen" src="<?= !empty($medidor['foto_inicial']) ? base_url('uploads/fotos/' . $medidor['foto_inicial']) : '' ?>" class="img-thumbnail" width="200">
                </div>
            </div>
        </fieldset>

        <!-- Grupo 7: Observaciones -->
        <fieldset class="border p-2 mb-4">
            <legend class="w-auto px-2 text-primary">Observaciones</legend>
            <div class="row">
                <div class="col-md-12">
                    <textarea class="form-control" rows="3" readonly><?= esc($medidor['observaciones']) ?></textarea>
                </div>
            </div>
        </fieldset>

        <div class="text-center mt-3">
            <a href="<?= base_url('medidores') ?>" class="btn btn-secondary px-4">Volver</a>
        </div>
    </div>
</div>
<?= $this->endSection(); ?>
