<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">

<style>
    .btn-buscar,
    .btn-crear {
        background-color: #2d5a86;
        color: white;
    }
    .btn-buscar:hover,
    .btn-crear:hover {
        background-color: #16A6BA;
        color: white;
    }
    input.form-control:focus {
        border: 2px solid #16A6BA;
        box-shadow: 0 0 6px rgba(22, 166, 186, 0.5);
        outline: none;
    }
</style>

<div class="container mt-3">
    <h2 class="fw-bold text-center mb-4" style="color: #2d5a86; font-size: 1.9rem;">
        Editar Predio
    </h2>

    <form action="<?= base_url('predios/update/' . $predio['gid']) ?>" method="post">
        <?= csrf_field() ?>

        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold text-primary">Información del Predio</legend>
            <div class="row g-2">
                <?php
                $campos = [
                    'cod_parcel'   => 'Codigo Parcela',
                    'cod_ubicac'   => 'Codigo Ubicacion',
                    'cod_fijo'     => 'Codigo Fijo',
                    'tipo_predi'   => 'Tipo de Predio',
                    'latitud'      => 'Latitud',
                    'longitud'     => 'Longitud',
                    'calle'        => 'Calle',
                    'nombres'      => 'Nombres',
                    'apellidos'    => 'Apellidos'
                ];

                foreach ($campos as $campo => $label): ?>
                    <div class="col-md-4">
                        <label for="<?= $campo ?>" class="form-label fw-bold"><?= $label ?></label>
                        <input type="text" name="<?= $campo ?>" id="<?= $campo ?>" value="<?= esc($predio[$campo] ?? '') ?>" class="form-control form-control-sm">
                    </div>
                <?php endforeach; ?>
            </div>
        </fieldset>

        <div class="text-center">
            <button type="submit" class="btn btn-primary px-4">Actualizar</button>
            <a href="<?= base_url('predios') ?>" class="btn btn-secondary px-4">Cancelar</a>
        </div>
    </form>
</div>

</section>
<?= $this->endSection(); ?>
