
<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">


<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
    /* Botones de acción */
    .acciones a {
        color: #2d5a86;
        margin-right: 10px;
        font-size: 1.1rem;
        transition: color 0.3s ease, background-color 0.3s ease;
        padding: 6px;
        border-radius: 5px;
        text-decoration: none;
    }
    .acciones a:hover {
        background-color: rgba(77, 130, 188, 0.1);
        color: #16A6BA;
    }
    .acciones a.eliminar:hover {
        background-color: rgba(255, 0, 0, 0.1);
        color: darkred;
    }

    /* Cabecera de la tabla */
    thead {
        background-color: #2d5a86;
        color: white;
    }
    thead th {
        text-align: center !important;
        vertical-align: middle !important;
    }

    /* Celdas del cuerpo */
    tbody td {
        text-align: center;
        vertical-align: middle;
    }
    tbody td.acciones {
        text-align: left;
    }

    /* Botones */
    .btn-buscar,
    .btn-crear {
        background-color: #2d5a86;
        color: white;
    }
    .btn-buscar:hover,
    .btn-crear:hover {
        background-color: #16A6BA;
        color: white;
    }

    /* Inputs al enfocar */
    input.form-control:focus {
        border: 2px solid #16A6BA;
        box-shadow: 0 0 6px rgba(22, 166, 186, 0.5);
        outline: none;
    }
</style>



<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Listado de Predios</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <h2 class="text-center mb-4">Listado de Predios</h2>

    <!-- Formulario de filtro -->
    <form class="row g-3 mb-4" method="get" action="<?= base_url('predios') ?>">
        <div class="col-md-3">
            <input type="text" name="calle" class="form-control" placeholder="Buscar por calle" value="<?= esc($search['calle'] ?? '') ?>">
        </div>
        <div class="col-md-3">
            <input type="text" name="nombres" class="form-control" placeholder="Buscar por nombres" value="<?= esc($search['nombres'] ?? '') ?>">
        </div>
        <div class="col-md-3">
            <input type="text" name="apellidos" class="form-control" placeholder="Buscar por apellidos" value="<?= esc($search['apellidos'] ?? '') ?>">
        </div>
        <div class="col-md-3 d-grid">
            <button type="submit" class="btn btn-primary">Filtrar</button>
        </div>
    </form>

    <div class="text-end mb-3">
        <a href="<?= base_url('predios/create') ?>" class="btn btn-success">Crear Predio</a>
    </div>

    <table class="table table-bordered table-striped">
        <thead class="table-dark">
        <tr>
            <th>Acciones</th>            
            <th>ID</th>
            <th>Calle</th>
            <th>Nombres</th>
            <th>Apellidos</th>
        </tr>
        </thead>
        <tbody>
        <?php foreach ($predios as $p): ?>
            <tr>
                <td>
                    <a href="<?= base_url('predios/show/' . $p['gid']) ?>" class="btn btn-info btn-sm">Ver</a>
                    <a href="<?= base_url('predios/edit/' . $p['gid']) ?>" class="btn btn-warning btn-sm">Editar</a>
                    <a href="<?= base_url('predios/delete/'. $p['gid']) ?>" class="btn btn-danger" onclick="return confirm('¿Estás seguro de eliminar este Predio?');">Eliminar</a>
                    <a href="<?= base_url('predios/verpredio_ol/' . $p['gid']) ?>" class="btn btn-info btn-sm">Mapa</a>

                </td>                
                <td><?= esc($p['gid']) ?></td>
                <td><?= esc($p['calle']) ?></td>
                <td><?= esc($p['nombres']) ?></td>
                <td><?= esc($p['apellidos']) ?></td>

            </tr>
        <?php endforeach ?>
        </tbody>
    </table>

    <!-- Paginación -->
    <div class="d-flex justify-content-center">
        <?= $pager->links() ?>
    </div>
</div>
</body>
</html>

<?= $this->endSection(); ?>


