
<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">


<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
    /* Botones de acción */
    .acciones a {
        color: #2d5a86;
        margin-right: 10px;
        font-size: 1.1rem;
        transition: color 0.3s ease, background-color 0.3s ease;
        padding: 6px;
        border-radius: 5px;
        text-decoration: none;
    }
    .acciones a:hover {
        background-color: rgba(77, 130, 188, 0.1);
        color: #16A6BA;
    }
    .acciones a.eliminar:hover {
        background-color: rgba(255, 0, 0, 0.1);
        color: darkred;
    }

    /* Cabecera de la tabla */
    thead {
        background-color: #2d5a86;
        color: white;
    }
    thead th {
        text-align: center !important;
        vertical-align: middle !important;
    }

    /* Celdas del cuerpo */
    tbody td {
        text-align: center;
        vertical-align: middle;
    }
    tbody td.acciones {
        text-align: left;
    }

    /* Botones */
    .btn-buscar,
    .btn-crear {
        background-color: #2d5a86;
        color: white;
    }
    .btn-buscar:hover,
    .btn-crear:hover {
        background-color: #16A6BA;
        color: white;
    }

    /* Inputs al enfocar */
    input.form-control:focus {
        border: 2px solid #16A6BA;
        box-shadow: 0 0 6px rgba(22, 166, 186, 0.5);
        outline: none;
    }
</style>

    <h2 class="fw-bold text-center mb-4" style="color: #2d5a86; font-size: 1.9rem;">
        Registrar Red de Alcantarillado
    </h2>

    <form action="<?= base_url('red_alcantarillado/store') ?>" method="post">

        <?= csrf_field() ?>

        <!-- Grupo 1: ID Tubería -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold" style="color: #2d5a86;">ID Tubería</legend>
            <div class="row">
                <div class="col-md-3">
                    <label for="id_tuberia" class="form-label fw-bold">ID Tubería</label>
                    <input type="number" name="id_tuberia" id="id_tuberia" class="form-control form-control-sm" required>
                </div>
            </div>
        </fieldset>

        <!-- Grupo 2: Características -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold" style="color: #2d5a86;">Características</legend>
            <div class="row g-2">
                <div class="col-md-3">
                    <label for="diametro" class="form-label fw-bold">Diámetro</label>
                    <input type="text" name="diametro" id="diametro" class="form-control form-control-sm">
                </div>
                <div class="col-md-3">
                    <label for="longitud" class="form-label fw-bold">Longitud</label>
                    <input type="number" step="0.01" name="longitud" id="longitud" class="form-control form-control-sm">
                </div>
                <div class="col-md-3">
                    <label for="material" class="form-label fw-bold">Material</label>
                    <input type="text" name="material" id="material" class="form-control form-control-sm">
                </div>
                <div class="col-md-3">
                    <label for="tipo_alcantarillado" class="form-label fw-bold">Tipo Alcantarillado</label>
                    <input type="text" name="tipo_alcantarillado" id="tipo_alcantarillado" class="form-control form-control-sm">
                </div>
                <div class="col-md-3">
                    <label for="pendiente" class="form-label fw-bold">Pendiente (%)</label>
                    <input type="text" name="pendiente" id="pendiente" class="form-control form-control-sm">
                </div>
                <div class="col-md-3">
                    <label for="profundidad" class="form-label fw-bold">Profundidad</label>
                    <input type="text" name="profundidad" id="profundidad" class="form-control form-control-sm">
                </div>
                <div class="col-md-3">
                    <label for="estado_actual" class="form-label fw-bold">Estado Actual</label>
                    <input type="text" name="estado_actual" id="estado_actual" class="form-control form-control-sm">
                </div>
            </div>
        </fieldset>

        <!-- Grupo 3: Ubicación -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold" style="color: #2d5a86;">Ubicación</legend>
            <div class="row g-2">
                <div class="col-md-4">
                    <label for="calle" class="form-label fw-bold">Calle</label>
                    <input type="text" name="calle" id="calle" class="form-control form-control-sm">
                </div>
                <div class="col-md-4">
                    <label for="ubicacion" class="form-label fw-bold">Ubicación</label>
                    <input type="text" name="ubicacion" id="ubicacion" class="form-control form-control-sm">
                </div>
                <div class="col-md-4">
                    <label for="dist_de_la_red" class="form-label fw-bold">Distancia de la Red</label>
                    <input type="text" name="dist_de_la_red" id="dist_de_la_red" class="form-control form-control-sm">
                </div>
                <div class="col-md-4">
                    <label for="otb" class="form-label fw-bold">OTB</label>
                    <input type="text" name="otb" id="otb" class="form-control form-control-sm">
                </div>
                <div class="col-md-4">
                    <label for="distrito" class="form-label fw-bold">Distrito</label>
                    <input type="text" name="distrito" id="distrito" class="form-control form-control-sm">
                </div>
                <div class="col-md-4">
                    <label for="municipio" class="form-label fw-bold">Municipio</label>
                    <input type="text" name="municipio" id="municipio" class="form-control form-control-sm">
                </div>
                <div class="col-md-4">
                    <label for="provincia" class="form-label fw-bold">Provincia</label>
                    <input type="text" name="provincia" id="provincia" class="form-control form-control-sm">
                </div>
                <div class="col-md-4">
                    <label for="departamento" class="form-label fw-bold">Departamento</label>
                    <input type="text" name="departamento" id="departamento" class="form-control form-control-sm">
                </div>
            </div>
        </fieldset>

        <!-- Grupo 4: Otros -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold" style="color: #2d5a86;">Otros</legend>
            <div class="row g-2">
                <div class="col-md-6">
                    <label for="responsable" class="form-label fw-bold">Responsable</label>
                    <input type="text" name="responsable" id="responsable" class="form-control form-control-sm">
                </div>
                <div class="col-md-6">
                    <label for="observaciones" class="form-label fw-bold">Observaciones</label>
                    <textarea name="observaciones" id="observaciones" rows="2" class="form-control form-control-sm"></textarea>
                </div>
            </div>
        </fieldset>

        <div class="text-center">
            <button type="submit" class="btn btn-primary px-4">Guardar</button>
            <a href="<?= base_url('red_alcantarillado') ?>" class="btn btn-secondary px-4">Cancelar</a>
        </div>
    </form>
</div>

<?= $this->endSection(); ?>


