<?php
function render_input_fields(array $campos, array $datos = [], array $tipos_especiales = [], $col = 'col-md-3') {
    foreach ($campos as $campo) {
        $type = $tipos_especiales[$campo] ?? 'text';
        $label = ucfirst(str_replace('_', ' ', $campo));
        $valor = esc($datos[$campo] ?? '');

        echo '<div class="' . $col . '">';
        echo '<label class="form-label fw-bold text-sm" style="color: #000;">' . $label . '</label>';
        echo '<input type="' . $type . '" class="form-control form-control-sm" name="' . $campo . '" value="' . $valor . '">';
        echo '</div>';
    }
}
?>

<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<!-- Estilos mantenidos del diseño original -->
<style>
    .acciones a {
        color: #2d5a86;
        margin-right: 10px;
        font-size: 1.1rem;
        transition: color 0.3s ease, background-color 0.3s ease;
        padding: 6px;
        border-radius: 5px;
        text-decoration: none;
    }
    .acciones a:hover {
        background-color: rgba(77, 130, 188, 0.1);
        color: #16A6BA;
    }
    .btn-buscar, .btn-crear {
        background-color: #2d5a86;
        color: white;
    }
    .btn-buscar:hover, .btn-crear:hover {
        background-color: #16A6BA;
        color: white;
    }
    input.form-control:focus {
        border: 2px solid #16A6BA;
        box-shadow: 0 0 6px rgba(22, 166, 186, 0.5);
        outline: none;
    }
</style>

<div class="container mt-3">
    <h4 class="text-center fw-bold mb-4" style="color: #2d5a86;">Editar Válvula</h4>

    <form action="<?= base_url('valvulas/update/' . $valvula['gid']) ?>" method="post" enctype="multipart/form-data">

        <!-- Grupo 1: Identificador -->
        <fieldset class="border p-3 mb-3">
            <legend class="w-auto px-3 fw-bold fs-5" style="color: #2d5a86;">Identificador</legend>
            <div class="row g-3">
                <div class="col-md-3">
                    <label for="id_valvula" class="form-label fw-bold">ID Válvula <span class="text-danger">*</span></label>
                    <input type="text" name="id_valvula" id="id_valvula" value="<?= esc($valvula['id_valvula'] ?? '') ?>" class="form-control form-control-sm" required>
                </div>
            </div>
        </fieldset>

        <!-- Grupo 2: Ubicación -->
        <fieldset class="border p-3 mb-3">
            <legend class="w-auto px-3 fw-bold fs-5" style="color: #2d5a86;">Ubicación</legend>
            <div class="row g-3">
                <?php
                $camposUbicacion = [
                    'este' => 'Este',
                    'norte' => 'Norte',
                    'cota' => 'Cota',
                    'ubicacion' => 'Ubicación',
                    'otb' => 'OTB',
                    'distrito' => 'Distrito',
                    'municipio' => 'Municipio',
                    'provincia' => 'Provincia',
                    'departamento' => 'Departamento'
                ];
                foreach ($camposUbicacion as $campo => $label): ?>
                    <div class="col-md-<?= ($campo === 'ubicacion') ? '4' : '2' ?>">
                        <label for="<?= $campo ?>" class="form-label fw-bold"><?= $label ?></label>
                        <input type="text" name="<?= $campo ?>" id="<?= $campo ?>" value="<?= esc($valvula[$campo] ?? '') ?>" class="form-control form-control-sm">
                    </div>
                <?php endforeach; ?>
            </div>
        </fieldset>

        <!-- Grupo 3: Características -->
        <fieldset class="border p-3 mb-3">
            <legend class="w-auto px-3 fw-bold fs-5" style="color: #2d5a86;">Características</legend>
            <div class="row g-3">
                <?php
                $camposCaracteristicas = [
                    'diametro' => 'Diámetro',
                    'tipo' => 'Tipo',
                    'funcion' => 'Función',
                    'edad' => 'Edad',
                    'estado' => 'Estado',
                    'tapa' => 'Tapa',
                    'responsable' => 'Responsable',
                    'descripcion' => 'Descripción'
                ];
                $camposRequeridos = ['tipo', 'funcion', 'estado', 'tapa'];
                foreach ($camposCaracteristicas as $campo => $label): ?>
                    <div class="col-md-3">
                        <label for="<?= $campo ?>" class="form-label fw-bold"><?= $label ?>
                            <?php if (in_array($campo, $camposRequeridos)): ?>
                                <span class="text-danger">*</span>
                            <?php endif; ?>
                        </label>
                        <?php if ($campo === 'tipo'): ?>
                            <select name="tipo" id="tipo" class="form-control form-control-sm" <?= in_array('tipo', $camposRequeridos) ? 'required' : '' ?>>
                                <option value="">-- Seleccione --</option>
                                <?php foreach ($tipoValvula as $opcion): ?>
                                    <option value="<?= esc($opcion['concepto']) ?>" <?= $valvula['tipo'] === $opcion['concepto'] ? 'selected' : '' ?>><?= esc($opcion['nombre']) ?></option>
                                <?php endforeach; ?>
                            </select>
                        <?php else: ?>
                            <?php if ($campo === 'funcion'): ?>
                                <select name="funcion" id="funcion" class="form-control form-control-sm" <?= in_array('funcion', $camposRequeridos) ? 'required' : '' ?>>
                                    <option value="">-- Seleccione --</option>
                                    <?php foreach ($funcionValvula as $opcion): ?>
                                        <option value="<?= esc($opcion['concepto']) ?>" <?= $valvula['funcion'] === $opcion['concepto'] ? 'selected' : '' ?>><?= esc($opcion['nombre']) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            <?php else: ?>
                                <?php if ($campo === 'estado'): ?>
                                    <select name="estado" id="estado" class="form-control form-control-sm" <?= in_array('estado', $camposRequeridos) ? 'required' : '' ?>>
                                        <option value="">-- Seleccione --</option>
                                        <?php foreach ($estadoValvula as $opcion): ?>
                                            <option value="<?= esc($opcion['concepto']) ?>" <?= $valvula['estado'] === $opcion['concepto'] ? 'selected' : '' ?>><?= esc($opcion['nombre']) ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                <?php else: ?>
                                    <?php if ($campo === 'tapa'): ?>
                                        <select name="tapa" id="tapa" class="form-control form-control-sm" <?= in_array('tapa', $camposRequeridos) ? 'required' : '' ?>>
                                            <option value="">-- Seleccione --</option>
                                            <?php foreach ($tapaValvula as $opcion): ?>
                                                <option value="<?= esc($opcion['concepto']) ?>" <?= $valvula['tapa'] === $opcion['concepto'] ? 'selected' : '' ?>><?= esc($opcion['nombre']) ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    <?php else: ?>
                        <input type="text" name="<?= $campo ?>" id="<?= $campo ?>" value="<?= esc($valvula[$campo] ?? '') ?>" class="form-control form-control-sm">
                                    <?php endif; ?>
                                <?php endif; ?>                        
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </fieldset>

        <!-- Botones -->
        <div class="text-center mb-5">
            <button type="submit" class="btn btn-sm px-4" style="background-color: #2d5a86; color: white;">Actualizar</button>
            <a href="<?= base_url('valvulas') ?>" class="btn btn-sm btn-secondary px-4 ms-2">Cancelar</a>
        </div>

    </form>
</div>

<?= $this->endSection(); ?>