<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
    .acciones a {
        color: #2d5a86;
        margin-right: 10px;
        font-size: 1.1rem;
        transition: color 0.3s ease, background-color 0.3s ease;
        padding: 6px;
        border-radius: 5px;
        text-decoration: none;
    }
    .acciones a:hover {
        background-color: rgba(77, 130, 188, 0.1);
        color: #16A6BA;
    }

    thead {
        background-color: #2d5a86;
        color: white;
    }

    .btn-buscar, .btn-crear {
        background-color: #2d5a86;
        color: white;
    }

    .btn-buscar:hover, .btn-crear:hover {
        background-color: #16A6BA;
        color: white;
    }

    input.form-control:focus {
        border: 2px solid #16A6BA;
        box-shadow: 0 0 6px rgba(22, 166, 186, 0.5);
        outline: none;
    }
</style>

<div class="container mt-3">
    <h2 class="fw-bold text-center mb-4" style="color: #2d5a86; font-size: 1.9rem;">
        Detalle de Válvula
    </h2>

    <div class="form">

        <!-- Grupo 1: Identificador -->
        <fieldset class="border p-2 mb-2">
            <legend class="w-auto px-2 fw-bold" style="color: #2d5a86;">Identificador</legend>
            <div class="row">
                <div class="col-md-3">
                    <label class="form-label fw-bold" style="color: #000;">ID Válvula</label>
                    <input type="text" class="form-control form-control-sm" value="<?= esc($valvula['id_valvula']) ?>" readonly>
                </div>
            </div>
        </fieldset>

        <!-- Grupo 2: Ubicación -->
        <fieldset class="border p-2 mb-2">
            <legend class="w-auto px-2 fw-bold" style="color: #2d5a86;">Ubicación</legend>
            <div class="row g-2">
                <?php
                $ubicacion = [
                    'ubicacion' => 'Ubicación',
                    'otb' => 'OTB',
                    'distrito' => 'Distrito',
                    'municipio' => 'Municipio',
                    'provincia' => 'Provincia',
                    'departamento' => 'Departamento',
                    'este' => 'Este',
                    'norte' => 'Norte',
                    'cota' => 'Cota'
                ];
                foreach ($ubicacion as $name => $label): ?>
                    <div class="col-md-3">
                        <label class="form-label fw-bold" style="color: #000;"><?= $label ?></label>
                        <input type="text" class="form-control form-control-sm" value="<?= esc($valvula[$name]) ?>" readonly>
                    </div>
                <?php endforeach; ?>
            </div>
        </fieldset>

        <!-- Grupo 3: Características -->
        <fieldset class="border p-2 mb-2">
            <legend class="w-auto px-2 fw-bold" style="color: #2d5a86;">Características</legend>
            <div class="row g-2">
                <?php
                $caracteristicas = [
                    'diametro' => 'Diámetro',
                    'tipo' => 'Tipo',
                    'funcion' => 'Función',
                    'edad' => 'Edad',
                    'estado' => 'Estado',
                    'tapa' => 'Tapa',
                    'responsable' => 'Responsable'
                ];
                foreach ($caracteristicas as $name => $label): ?>
                    <div class="col-md-3">
                        <label class="form-label fw-bold" style="color: #000;"><?= $label ?></label>
                        <input type="text" class="form-control form-control-sm" value="<?= esc($valvula[$name]) ?>" readonly>
                    </div>
                <?php endforeach; ?>
            </div>
        </fieldset>

        <!-- Grupo 4: Descripción -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold" style="color: #2d5a86;">Descripción</legend>
            <label class="form-label fw-bold" style="color: #000;">Descripción</label>
            <textarea rows="3" class="form-control form-control-sm" readonly><?= esc($valvula['descripcion']) ?></textarea>
        </fieldset>

        <!-- Botón volver -->
        <div class="text-center mt-3">
            <a href="<?= base_url('valvulas') ?>" class="btn btn-sm btn-secondary px-4">Volver</a>
        </div>
    </div>
</div>

<?= $this->endSection(); ?>
